/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl.persist;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rbf.RbfRequest;

public class PersistableRequestBody
implements Persistable {
    private Object body = null;
    private boolean upgradeData = false;

    public PersistableRequestBody(RbfRequest request) {
        this.body = request.getBody();
        this.upgradeData = request.isUpgradeData();
    }

    public PersistableRequestBody(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        int rbfVersion = persistent.rbfVersion;
        this.body = persistent.body == null ? null : pm.containedFormToObject(persistent.body);
        this.upgradeData = persistent.upgradeData;
    }

    public Object getBody() {
        return this.body;
    }

    public boolean isUpgradeData() {
        return this.upgradeData;
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        persistent.rbfVersion = 2;
        persistent.body = this.body == null ? null : pm.objectToContainedForm(this.body);
        persistent.upgradeData = this.upgradeData;
        return persistent;
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = 5637474532328840373L;
        int rbfVersion;
        Object body;
        boolean upgradeData;

        private Persistent() {
        }
    }
}

